<?php
/**
 * HouseHelp
 *
 * @category   Application_Core
 * @package    Core
 * @copyright  Copyright 2006-2010 Fly Developments
 * @license    
 * @version    $Id: index.tpl 9747 2012-07-26 02:08:08Z john $
 * @author     Jung
 */
?>

<h2><?php echo $this->translate("Language Manager") ?></h2>

<p>
  <?php echo $this->translate("CORE_VIEWS_SCRIPTS_ADMINLANGUAGE_INDEX_DESCRIPTION") ?>
</p>

<br />

<?php
  $settings = Engine_Api::_()->getApi('settings', 'core');
  if( $settings->getSetting('user.support.links', 0) == 1 ) {
    echo 'More info: <a href="http://anonym.to/http://support.househelp.com/questions/218/Admin-Panel-Layout-Language-Manager" target="_blank">See KB article</a>.';	
  } 
?>	

<br />

<script type="text/javascript">
  var changeDefaultLanguage = function(locale) {
    var url = '<?php echo $this->url(array('module'=>'core','controller'=>'language','action'=>'default')) ?>';

    var request = new Request.JSON({
      url : url,
      data : {
        locale : locale,
        format : 'json'
      },
      onComplete : function() {
        window.location.replace( window.location.href );
      }
    });
    request.send();
  }
</script>

<br />

<div class="admin_language_options">
  <a href="<?php echo $this->url(array('action' => 'create')) ?>" class="buttonlink admin_language_options_new"><?php echo $this->translate("Create New Pack") ?></a>
  <a href="<?php echo $this->url(array('action' => 'upload')) ?>" class="buttonlink admin_language_options_upload"><?php echo $this->translate("Upload New Pack") ?></a>
</div>

<br />

<table class="admin_table admin_languages">
  <thead>
    <tr>
      <th><?php echo $this->translate("Language") ?></th>
      <th><?php echo $this->translate("Options") ?></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach( $this->languageNameList as $locale => $translatedLanguageTitle ): ?>
      <tr>
        <td>
          <?php echo $translatedLanguageTitle ?>
        </td>
        <td class="admin_table_options">
          <a href="<?php echo $this->url(array('action' => 'edit', 'locale' => $locale)) ?>"><?php echo $this->translate("edit phrases") ?></a>
          | <a href="<?php echo $this->url(array('action' => 'export', 'locale' => $locale)) ?>"><?php echo $this->translate("export") ?></a>
          <?php if( $this->defaultLanguage != $locale ): ?>
            | <?php echo $this->htmlLink('javascript:void(0);', $this->translate('make default'), array('onclick' => 'changeDefaultLanguage(\'' . $locale . '\');')) ?>
            | <?php echo $this->htmlLink(array('module'=>'core','controller'=>'language','action'=>'delete',  'locale'=>$locale), $this->translate('delete'), array('class'=>'smoothbox')) ?>
          <?php else: ?>
            | <?php echo $this->translate("default") ?>
          <?php endif; ?>
          
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
