<?php
/**
 * HouseHelp
 *
 * @category   Application_Core
 * @package    User
 * @copyright  Copyright 2006-2010 Fly Developments
 * @license    
 * @author     John
 */
return array(
  '4.8.10' => array(
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'widgets/profile-info/index.tpl' => 'Added missing translation',
    'Form/Admin/Settings/Friends.php' => 'Fixed transaction error that appeared when using PHP\'s PDO adapter',
    'Model/DbTable/Lists.php' => 'Fixed log error that was coming when a user was removing another user from being a friend.',
    'Plugin/Signup/Account.php' => 'Added new fields in the query being used to call Facebook API which fixed the issue with email not getting populated during signup via Facebook',
  ),
  '4.8.9' => array(
    'controllers/AuthController.php' => 'Fixed compatibility issue with Facebook that was coming because of some permission related changes done by Facebook',
    'controllers/AdminSettingsController.php' => 'Hide keys of Facebook and Twitter when _ENGINE_ADMIN_NEUTER mode is enabled.',
    'Form/Signup/Account.php' => 'Fixed issue with Name field of Signup form that was conflicting with another form\'s Name field when existing on same page',
    'Model/User.php' => 'Fixed issue with profile photo isn\'t being uploaded correctly using iPad',
    'Plugin/Signup/Account.php' => 'Fixed issue with admin emails show incorrect time zone',
    'Plugin/Signup/Photo.php' => 'Fixed issue with profile photo isn\'t being uploaded correctly using iPad',
    'Plugin/Core.php' => 'Fixed issue with newly registered members are receiving two emails: "Welcome email" and "Welcome email with Password"',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/signup/form/account.tpl' => 'Fixed issue with Name field of Signup form that was conflicting with another form\'s Name field when existing on same page',
    'views/scripts/_formSignupImage.tpl' => 'Fixed javascript error',
    'widgets/home-photo/Controller.php' => 'Fixed log error while accessing Albums section being a non-logged-in user',
  ),
  '4.8.7' => array(
    '/application/languages/en/user.csv' => 'Improved message that is displayed in user settings when a user has restricted their "Profile Privacy" to "Only me"',
    'controllers/AuthController.php' => 'Fixed compatibility issue with Facebook that was coming because of some permission related changes done by Facebook',
    'controllers/EditController.php' => 'Fixed a bug with menu editor where any custom menu added to Member Edit Profile Navigation was redirecting to Browse Members page',
    'controllers/FriendsController.php' => 'Fixed issue with the auto-suggestion field of compose message form not working fine when "Profile Address" field is disabled from signup process settings',
    'controllers/IndexController.php' => 'Made "Browse Members" page available for editing in Layout Editor',
    'controllers/SignupController.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Form/Admin/Facebook.php' => 'Improved text',
    'Form/Admin/Manage/Edit.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Form/Auth/Forgot.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Form/Login.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Form/Search.php' => 'Changed form submission method from post to get',
    'Form/Settings/General.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Form/Signup/Account.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Form/Signup/Invite.php' => 'Removed unnecessary TLD check performed at the time of email addresses validation',
    'Model/User.php' => 'Fixed issue that deleted users\' entries were not being deleted from email verification database table',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => ' Added widgets to make "Browse Members" page available in Layout Editor',
    'settings/install.php' => 'Added a new page "Browse Members" in Layout Editor',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.8.6-4.8.7.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/index/browse.tpl' => 'Added a new page "Browse Members" in Layout Editor',
    'widgets/browse-menu/*' => 'Added a new widget for displaying menu on "Browse Members" page',
    'widgets/browse-search/*' => 'Added a new widget of search on "Browse Members" page',
    'widgets/login-or-signup/Controller.php' => 'Fixed issue that was coming when anti-spamming technique and re-captcha are both enabled in login / signup forms',
    'widgets/profile-status/index.tpl' => 'Improved message that is displayed in user settings when a user has restricted their "Profile Privacy" to "Only me"',
  ),
  '4.8.6' => array(
    'controllers/EditController.php' => 'Fixed bug with menu editor where any custom menu added to Member Edit Profile Navigation was redirecting to Browse Members page',
    'Form/Login.php' => 'Modified email field for anti-spamming technique',
    'Form/Signup/Account.php' => 'Modified email field for anti-spamming technique',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.8.5' => array(
    'controllers/FriendsController.php' => 'Fix To form auto-complete in mail message compose',
    'externals/styles/mobile.css' => 'Added all mobile profile options',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'settings/changelog.php' => 'Incremented version',
  ),
  '4.8.3' => array(
    'controllers/FriendsController.php' => 'Fixed a bug where auto-suggest would only ever suggest friends',
    'controllers/AdminLoginsController.php' => 'Login history now sorts by timestamp by default',
    'Plugin/Signup/Photo.php' => 'If sign-ups require a photo, mobile sign-ups will also require a photo',
    'settings/my.sql' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
  ),
  '4.8.2' => array(
    'Form/Signup/Invite.php' => 'Added option to automatically friend request invited members',
    'Plugin/Signup/Invite.php' => 'Added option to automatically friend request invited members',
    'controllers/AdminLoginsController.php' => 'Added ability to sort and filter login history',
    'widgets/profile-fields/Controller.php' => 'Removed inaccessible code.',
    'controllers/AjaxController.php' => 'Fixed an undeclared variable error.',
    'Form/Admin/Account.php' => 'Removed',
    'Signup/Photo.php' => 'Removed dead code',
    'Model/List.php' => 'Removed deprecated code',
    'settings/my.sql' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
  ),
  '4.8.1' => array(
    'widgets/list-popular/index.tpl' => 'Fixed inconsistent alt-text for profile photos',
    'widgets/list-signups/index.tpl' => 'Fixed inconsistent alt-text for profile photos',
    'widgets/profile-info/index.tpl' => 'Fixed a bug where a user with no last-modified date would display as December -1',
    'settings/my.sql' => 'Incremented version',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
  ),
  '4.8.0' => array(
    '/application/languages/en/user.csv' => 'Added missing phrases',
    'controllers/AuthController.php' => 'Fixed Facebook redirection at sign-in',
    'Form/Login.php' => 'Always display ReCaptcha for sign-ins (if enabled)',
    'Form/Signup/Account.php' => 'Bot sign-up mitigation',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/signup/form/account.tpl' => 'Bot sign-up mitigation',
    'widgets/profile-friends/index.tpl' => 'Fixed a minor problem',
  ),
  '4.7.0' => array(
    '/application/languages/en/user.csv' => 'Added phrases and fixed a typo',
    'controllers/AuthController.php' => 'Show a captcha only after some failed attempts',
    'controllers/IndexController.php' => 'Fixed a bug in the search function',
    'externals/images/*' => 'Optimized images',
    'Form/Login.php' => 'Show a captcha only after some failed attempts',
    'Model/DbTable/Membership.php' => 'Fixed a warning',
    'Plugin/Signup/Account.php' => 'Fixed a warning',
    'views/scripts/settings/network.tpl' => 'Minimized Autocompleter.js',
    'settings/my.sql' => 'Incremented version',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
  ),
  '4.6.0' => array(
    'externals/styles/main.css' => 'Fixed style issue with field privacy and headings',
    'Form/Settings/General.php' => 'Fixed issue with publishing to twitter',
    'Plugin/Signup/Photo.php' => 'Fixed issue preventing requiring a photo to be bypassed',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.5.0' => array(
    'controllers/AdminSettingsController.php' => 'Using SSL for Twitter',
    'controllers/AuthController.php' => 'Using SSL for Twitter',
    'controllers/SettingsController.php' => 'Style improvement',
    'externals/images/field-privacy/friends.png' => 'Correct image',
    'externals/images/field-privacy/registered.png' => 'Correct image',
    'externals/scripts/core.js' => 'Language support for field privacy options',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_browseUsers.tpl' => 'Removed empty div when no results',
    'views/scripts/edit/profile.tpl' => 'Language support for field privacy options',
    'views/scripts/index/search.tpl' => 'Removed empty div when no results',
    'views/scripts/settings/delete.tpl' => 'Style improvement',
    'views/scripts/settings/network.tpl' => 'Added missing translation',
    'widgets/profile-info/index.tpl' => 'Setting active class on main menu',
    'widgets/settings-menu/Controller.php' => 'Hides delete account if last super admin',
  ),
  '4.3.0' => array(
    'controllers/AdminManageController.php' => 'Approving a member will now add a signup action',
    'controllers/AjaxController.php' => 'Added ability to set privacy on specific profile fields',
    'controllers/AuthController.php' => 'Added new pages to layout editor',
    'controllers/EditController.php' => 'Added ability to set privacy on specific profile fields',
    'controllers/SettingsController.php' => 'Added new pages to layout editor; Removed usage of action helper to prevent issues',
    'externals/images/field-privacy/everyone.png' => 'Added',
    'externals/images/field-privacy/friends.png' => 'Added',
    'externals/images/field-privacy/registered.png' => 'Added',
    'externals/images/field-privacy/self.png' => 'Added',
    'externals/scripts/core.js' => 'Added ability to set privacy on specific profile fields',
    'externals/styles/main.css' => 'Added ability to set privacy on specific profile fields',
    'Model/DbTable/Janrain.php' => 'Fixed issue with Janrain social sharing widget',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added new pages to layout editor',
    'settings/install.php' => 'Added new pages to layout editor',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.2.8-4.3.0.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'View/Helper/Friends.php' => 'Added',
    'views/scripts/admin-manage/index.tpl' => 'Improved admin panel styles',
    'views/scripts/edit/profile.tpl' => 'Added ability to set privacy on specific profile fields',
    'views/scripts/settings/delete.tpl' => 'Added new pages to layout editor',
    'views/scripts/settings/general.tpl' => 'Added new pages to layout editor',
    'views/scripts/settings/network.tpl' => 'Added new pages to layout editor; Removed usage of action helper to prevent issues',
    'views/scripts/settings/notifications.tpl' => 'Added new pages to layout editor',
    'views/scripts/settings/password.tpl' => 'Added new pages to layout editor',
    'views/scripts/settings/privacy.tpl' => 'Added new pages to layout editor',
    'widgets/settings-menu/Controller.php' => 'Added',
    'widgets/settings-menu/index.tpl' => 'Added',
  ),
  '4.2.8' => array(
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.7' => array(
    'Plugin/Menus.php' => 'Add option for Moderator to delete member',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/signup/form/account.tpl' => 'Fixes a few XSS vulnerabilities with the Tags and Profile name fields',
    'views/scripts/signup/resend.tpl' => 'Fixes Typo',
  ),
  '4.2.6' => array(
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.5' => array(
    'Form/Admin/Settings/Friends.php' => 'Member count on User table messed up when switching between 1-way and 2-way friendshipst',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_browseUsers.tpl' => 'Disallows add friend on browse member page when member is blocked',
    'widgets/profile-info/index.tpl' => 'Member count on User table messed up when switching between 1-way and 2-way friendships',
  ),
  '4.2.4' => array(
    '/application/languages/en/user.csv' => 'Change Verification Message',
    'Form/Admin/Facebook.php' => 'Added support links in admin panel',
    'Form/Admin/Signup/Account.php' => 'Fixes language on Notify Admin Signup Process form',
    'Form/Admin/Twitter.php' => 'Added support links in admin panel',
    'Form/Signup/Photo.php' => 'Fixes language on Notify Admin Signup Process form',
    'Plugin/Signup/Account.php' => 'Fixes language on Notify Admin Signup Process form',
    'Plugin/Signup/Fields.php' => 'Fixes language on Notify Admin Signup Process form',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Fixes banned IP address to be erased after performing an upgrade',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formEditImage.tpl' => 'Fixes Photo Required error',
    'views/scripts/_formSignupImage.tpl' => 'Fixes Photo Required error',
    'views/scripts/admin-fields/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-signup/index.tpl' => 'Added support links in admin panel',
    'views/scripts/signup/verify.tpl' => 'Fixes Photo Required error',
  ),
  '4.2.3p1' => array(
    '/application/languages/en/user.csv' => 'Fixes Photo Required error',
    'Form/Admin/Signup/Account.php' => 'Fixes Photo Required error',
    'Form/Signup/Photo.php' => 'Fixes Photo Required error',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formEditImage.tpl' => 'Fixes Photo Required error',
    'views/scripts/_formSignupImage.tpl' => 'Fixes Photo Required error',
  ),
  '4.2.3' => array(
    '/application/languages/en/user.csv' => 'Rewrite Profile viewing and Profile Commenting Options Descriptions',
    'Form/Admin/Signup/Account.php' => 'Admin can choose to receive email when a new user signs up',
    'Model/User.php' => 'Removes Admin Settings link for moderator on member profile',
    'Plugin/Menus.php' => 'Removes Admin Settings link for moderator on member profile',
    'Plugin/Signup/Account.php' => 'Admin can choose to receive email when a new user signs up',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formEditImage.tpl' => 'Wraps translation for Edit Thumbnail to allow apostrophes',
    'views/scripts/_formSignupImage.tpl' => 'Wraps translation for Edit Thumbnail to allow apostrophes',
    'views/scripts/admin-manage/index.tpl' => 'Added support links in admin panel',
    'views/scripts/settings/network.tpl' => 'Added support links in admin panel',
    'widgets/profile-status/index.tpl' => 'Fixes Profile Status widget title separation',
  ),
  '4.2.2' => array(
    'controllers/AdminManageController.php' => 'Fixed errors when usernames are disabled',
    'controllers/AdminSettingsController.php' => 'Added support for Janrain\'s custom domains',
    'controllers/AuthController.php' => 'Added redirect URIs to facebook and twitter',
    'Form/Admin/Janrain.php' => 'Added support for Janrain\'s custom domains',
    'Form/Signup/Account.php' => 'Changed timezone',
    'Form/Signup/Photo.php' => 'Added ability to require a photo on signup',
    'Model/DbTable/Janrain.php' => 'Added support for Janrain\'s custom domains; removed supplied action text',
    'Model/DbTable/Membership.php' => 'Changing function params',
    'Model/User.php' => 'Changing function params',
    'Plugin/Signup/Fields.php' => 'Added more pre-population of data from Janrain',
    'Plugin/Signup/Photo.php' => 'Added ability to require a photo on signup',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.1' => array(
    'controllers/AdminSettingsController.php' => 'Added missing neutering',
    'controllers/AuthController.php' => 'Fixed notice',
    'controllers/BlockController.php' => 'Blocking removes notifications of friend request',
    'controllers/EditController.php' => 'Fixed issue preventing photo edit page from being accessible when profile styles are disabled',
    'controllers/IndexController.php' => 'Improved error handling',
    'controllers/SettingsController.php' => 'Added ability to disable Janrain share modal',
    'externals/styles/main.css' => 'Fixed CSS issue with Janrain modal',
    'Form/Admin/Janrain.php' => 'Fixed Janrain link',
    'Form/Admin/Signup/Photo.php' => 'Admin can disable skipping of uploading a photo',
    'Form/Settings/General.php' => 'Added ability to disable Janrain share modal',
    'Form/Signup/Photo.php' => 'Admin can disable skipping of uploading a photo',
    'Model/DbTable/Settings.php' => 'Fixed issue with deleting a setting',
    'Plugin/Menus.php' => 'Fixed issue preventing photo edit page from being accessible when profile styles are disabled',
    'Plugin/Signup/Photo.php' => 'Admin can disable skipping of uploading a photo',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.2.0-4.2.1.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'widgets/profile-friends-followers/Controller.php' => 'Removed usage of $view->viewer() and $view->subject()',
    'widgets/profile-friends-followers/index.tpl' => 'Removed usage of $view->viewer() and $view->subject()',
    'widgets/profile-friends-following/Controller.php' => 'Removed usage of $view->viewer() and $view->subject()',
    'widgets/profile-friends-following/index.tpl' => 'Removed usage of $view->viewer() and $view->subject()',
  ),
  '4.2.0' => array(
    '/application/languages/en/user.csv' => 'Added phrases',
    'controllers/AdminManageController.php' => 'Fixed incorrect link in email; admins can no longer promote themselves to superadmin or demote superadmins to admin',
    'controllers/AdminSettingsController.php' => 'Added Janrain',
    'controllers/AuthController.php' => 'Added Janrain',
    'controllers/FriendsController.php' => 'Fixed error when rejecting a friend request',
    'controllers/ProfileController.php' => 'Admins can new view a profile even if they have been blocked by that member',
    'controllers/SettingsController.php' => 'Added notice to form save',
    'externals/images/janrain/aol.png' => 'Added',
    'externals/images/janrain/blogger.png' => 'Added',
    'externals/images/janrain/facebook.png' => 'Added',
    'externals/images/janrain/flickr.png' => 'Added',
    'externals/images/janrain/foursquare.png' => 'Added',
    'externals/images/janrain/google.png' => 'Added',
    'externals/images/janrain/hyves.png' => 'Added',
    'externals/images/janrain/linkedin.png' => 'Added',
    'externals/images/janrain/live_id.png' => 'Added',
    'externals/images/janrain/livejournal.png' => 'Added',
    'externals/images/janrain/mixi.png' => 'Added',
    'externals/images/janrain/myopenid.png' => 'Added',
    'externals/images/janrain/myspace.png' => 'Added',
    'externals/images/janrain/netlog.png' => 'Added',
    'externals/images/janrain/openid.png' => 'Added',
    'externals/images/janrain/orkut.png' => 'Added',
    'externals/images/janrain/paypal.png' => 'Added',
    'externals/images/janrain/salesforce.png' => 'Added',
    'externals/images/janrain/twitter.png' => 'Added',
    'externals/images/janrain/verisign.png' => 'Added',
    'externals/images/janrain/vzn.png' => 'Added',
    'externals/images/janrain/wordpress.png' => 'Added',
    'externals/images/janrain/yahoo.png' => 'Added',
    'externals/scripts/composer_facebook.js' => 'Added namespace for Wibiya compatibility',
    'externals/scripts/composer_twitter.js' => 'Added namespace for Wibiya compatibility',
    'externals/scripts/core.js' => 'Added namespace for Wibiya compatibility',
    'Form/Admin/Janrain.php' => 'Added',
    'Form/Admin/Manage/Filter.php' => 'Added ability to display a single user',
    'Form/Login.php' => 'Added Janrain; added ReCaptcha',
    'Form/Settings/General.php' => 'Added Janrain',
    'Form/Signup/Account.php' => 'Added Janrain; added ReCaptcha',
    'Model/DbTable/Janrain.php' => 'Added',
    'Plugin/Core.php' => 'Fixed incorrect link in email',
    'Plugin/Menus.php' => 'Added link to admin member edit page for admins on the member profile; hiding add friend for blocked members',
    'Plugin/Signup/Account.php' => 'Added Janrain; added ReCaptcha',
    'Plugin/Signup/Fields.php' => 'Fixed issue with sending the welcome email',
    'Plugin/Signup/Photo.php' => 'Added Janrain',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.8p1-4.2.0.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-manage/index.tpl' => 'Added ability to view a single user',
    'views/scripts/admin-manage/stats.tpl' => 'Fixed error when member is missing the creation IP',
    'views/scripts/admin-settings/janrain-import.tpl' => 'Added',
    'views/scripts/admin-settings/janrain.tpl' => 'Added',
    'views/scripts/auth/janrain.tpl' => 'Added',
    'views/scripts/settings/network.tpl' => 'Added missing translation',
    'views/scripts/signup/verify.tpl' => 'Fixed incorrect message',
    'widgets/home-photo/Controller.php' => 'Fixed caching issue',
    'widgets/login-or-signup/Controller.php' => 'Added Janrain; Fixed issue with ReCaptcha being too large for left column',
    'widgets/login-or-signup/index.tpl' => 'Fixed issue with ReCaptcha being too large for left column',
    'widgets/profile-info/Controller.php' => 'Added display of whether or not the member is enabled to admins',
    'widgets/profile-info/index.tpl' => 'Added display of whether or not the member is enabled to admins',
  ),
  '4.1.8p1' => array(
    'Api/Core.php' => 'Changed random password generation method to fix rare timeout issues',
    'controllers/AdminManageController.php' => 'Fixed email link issue',
    'controllers/FriendsController.php' => 'Fixed broken friend suggestions',
    'controllers/IndexController.php' => 'Fixed pagination issue with browse members',
    'externals/scripts/composer_facebook.js' => 'Removed unused options',
    'externals/scripts/composer_twitter.js' => 'Removed unused options',
    'Form/Admin/Manage/Filter.php' => 'Fixed array_merge issue',
    'Model/User.php' => 'Fixed error caused by unimplemented code',
    'Plugin/Signup/Photo.php' => 'Store coordinates in session',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formSignupImage.tpl' => 'Fixed typo in URL',
    'widgets/profile-friends-common/index.tpl' => 'Removed duplicate title',
  ),
  '4.1.8' => array(
    '/application/languages/en/user.csv' => 'Added phrases',
    'Api/Core.php' => 'Removed deprecated method calls; ereg to preg',
    'controllers/AdminManageController.php' => 'Fixed issue with email validation',
    'controllers/AdminSettingsController.php' => 'Removed deprecated routes and code',
    'controllers/AuthController.php' => 'Added pages to the layout editor; added single sign out',
    'controllers/EditController.php' => 'Removed deprecated method calls',
    'controllers/IndexController.php' => 'Fixed issue with using incorrect values in field search',
    'controllers/SettingsController.php' => 'Removed activity feed item types that did not make sense to be configurable (status, post)',
    'controllers/SignupController.php' => 'Added pages to the layout editor',
    'externals/.htaccess' => 'Updated with far-future expires headers for static resources',
    'externals/html/channel.html' => 'Added',
    'externals/images/google-sign-in.png' => 'Added',
    'externals/scripts/composer_twitter.js' => 'Added svn:keywords',
    'externals/styles/main.css' => 'Style tweaks',
    'externals/styles/mobile.css' => 'Style tweaks',
    'Form/Admin/Facebook.php' => 'Added trim to input',
    'Form/Admin/Manage/Edit.php' => 'Added StringTrim filter to e-mail address element',
    'Form/Admin/Twitter.php' => 'Added trim to input',
    'Form/Login.php' => 'Added HTML5 features',
    'Form/Settings/General.php' => 'Added StringTrim filter to e-mail address element',
    'Form/Signup/Account.php' => 'Added HTML5 features',
    'Model/DbTable/Facebook.php' => 'Added static base URL for CDN support',
    'Model/DbTable/Online.php' => 'Fixed issue with locking in the online users table',
    'Model/DbTable/Settings.php' => 'Added svn:keywords',
    'Model/DbTable/Twitter.php' => 'Added static base URL for CDN support',
    'Model/User.php' => 'Removed deprecated method calls',
    'Plugin/Menus.php' => 'Removed deprecated routes',
    'Plugin/Signup/Account.php' => 'Sets locale to be the same as language on signup',
    'Plugin/Signup/Fields.php' => 'Fixed rare fatal error',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Added pages to the layout editor',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_composeFacebook.tpl' => 'Added static base URL for CDN support',
    'views/scripts/_composeTwitter.tpl' => 'Added static base URL for CDN support',
    'views/scripts/_formEditImage.tpl' => 'Added static base URL for CDN support',
    'views/scripts/_formSignupImage.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-manage/index.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-settings/google.tpl' => 'Added',
    'views/scripts/admin-settings/twitter.tpl' => 'Added svn:keywords',
    'views/scripts/auth/google.tpl' => 'Added',
    'views/scripts/auth/logout.tpl' => 'Added',
    'views/scripts/auth/twitter.tpl' => 'Added svn:keywords',
    'views/scripts/friends/list.tpl' => 'Added static base URL for CDN support',
    'views/scripts/index/browse.tpl' => 'Compatibility for AJAX page loader',
    'views/scripts/index/search.tpl' => 'Added static base URL for CDN support',
    'views/scripts/profile/activity.tpl' => 'Removed',
    'views/scripts/profile/fields.tpl' => 'Removed',
    'views/scripts/profile/index.tpl' => 'Removed',
    'views/scripts/profile/info.tpl' => 'Removed',
    'views/scripts/profile/options.tpl' => 'Removed',
    'views/scripts/profile/photo.tpl' => 'Removed',
    'views/scripts/profile/status.tpl' => 'Removed',
    'views/scripts/profile/tabs.tpl' => 'Removed',
    'views/scripts/settings/network.tpl' => 'Added static base URL for CDN support',
    'widgets/list-signups/Controller.php' => 'Fixed caching issue',
    'widgets/profile-friends-common/Controller.php' => 'Fixed issue where title would not be displayed when placed outside a tab container widget',
    'widgets/profile-friends-followers/Controller.php' => 'Fixed issue where title would not be displayed when placed outside a tab container widget',
    'widgets/profile-friends-following/Controller.php' => 'Fixed issue where title would not be displayed when placed outside a tab container widget',
    'widgets/profile-friends/Controller.php' => 'Fixed issue where title would not be displayed when placed outside a tab container widget',
  ),
  '4.1.7' => array(
    'Api/Core.php' => 'Minor optimizations',
    'controllers/AdminManageController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/AdminSignupController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/AjaxController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/AuthController.php' => 'Adjustments to user disable handling on login; fixed issues with twitter and facebook sign-in',
    'controllers/BlockController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/EditController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/SettingsController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/SignupController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'Form/Admin/Manage/Filter.php' => 'Minor optimizations',
    'Form/Signup/Account.php' => 'Added twitter and facebook sign-up support',
    'Form/Signup/Invite.php' => 'Added missing translation',
    'Model/Api.php' => 'Removed',
    'Model/User.php' => 'Added twitter and facebook sign-up support',
    'Plugin/Core.php' => 'Fixed enabled count in admin dashboard; fixed issue where facebook and twitter credentials would not be deleted when a member deleted their account',
    'Plugin/Signup/Account.php' => 'Added twitter and facebook sign-up support',
    'Plugin/Signup/Fields.php' => 'Added twitter and facebook sign-up support',
    'Plugin/Signup/Photo.php' => 'Added twitter and facebook sign-up support',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/auth/twitter.tpl' => 'Added',
    'views/scripts/friends/request-friend.tpl' => 'Code formatting',
    '/application/languages/en/user.csv' => 'Added phrase',
  ),
  '4.1.6p3' => array(
    'controllers/AuthController.php' => 'Fixed issue where modifying the Twitter application would cause errors when previously obtained access tokens were rendered invalid',
    'Form/Admin/Facebook.php' => 'Improved description',
    'Form/Admin/Twitter.php' => 'Improved description',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    '/application/languages/en/user.csv' => 'Modified phrases',
  ),
  '4.1.6p2' => array(
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    '/application/languages/en/user.csv' => 'Added phrases',
  ),
  '4.1.6p1' => array(
    'Model/DbTable/Online.php' => 'Fixed issue where certain IP address would cause an exception',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.1.6' => array(
    'controllers/AdminManageController.php' => 'Fixed pagination issue',
    'controllers/AdminSettingsController.php' => 'Added twitter integration',
    'controllers/AuthController.php' => 'Added twitter integration; updated facebook integration; added IPv6 support; added login tracking for facebook and twitter integrations',
    'controllers/SettingsController.php' => 'Added twitter integration; updated facebook integration; added banned emails and banned usernames',
    'controllers/SignupController.php' => 'Added banned emails and banned usernames',
    'externals/images/facebook-sign-in.png' => 'Added',
    'externals/images/twitter-sign-in.png' => 'Added',
    'externals/scripts/composer_twitter.js' => 'Added',
    'Form/Login.php' => 'Added twitter integration',
    'Form/Admin/Facebook.php' => 'Updated facebook integration',
    'Form/Admin/Twitter.php' => 'Added twitter integration',
    'Form/Settings/General.php' => 'Added twitter integration; updated facebook integration; added banned emails and banned usernames',
    'Form/Signup/Account.php' => 'Added banned emails and usernames',
    'Model/User.php' => 'Added IPv6 support',
    'Model/DbTable/Facebook.php' => 'Updated facebook integration',
    'Model/DbTable/Online.php' => 'Added IPv6 support',
    'Model/DbTable/Settings.php' => 'Added',
    'Model/DbTable/Twitter.php' => 'Added twitter integration',
    'Plugin/Core.php' => 'Removed deprecated code',
    'Plugin/Signup/Account.php' => 'Added banned emails and banned usernames',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Added IPv6 support',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.5-4.1.6.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_composeFacebook.tpl' => 'Updated facebook integration',
    'views/scripts/_composeTwitter.tpl' => 'Added twitter integration',
    'views/scripts/admin-logins/index.tpl' => 'Added IPv6 support',
    'views/scripts/admin-manage/stats.tpl' => 'Added IPv6 support',
    'views/scripts/admin-settings/facebook.tpl' => 'Updated facebook integration',
    'views/scripts/admin-settings/twitter.tpl' => 'Added twitter integration',
    'views/scripts/auth/facebook-cancel.tpl' => 'Removed',
    'views/scripts/auth/facebook-success.tpl' => 'Removed',
    'widgets/login-or-signup/Controller.php' => 'Removed deprecated code',
  ),
  '4.1.5' => array(
    'controllers/AdminManageController.php' => 'Fixed pagination issue',
    'controllers/SignupController.php' => 'Fixed issue with members being disabled after signup when payment is enabled',
    'Form/Login.php' => 'Added autofocus to email field (HTML5)',
    'Form/Signup/Account.php' => 'Fixed language list display issue',
    'Model/User.php' => 'Fixed error with default timezones when new members are created',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.4-4.1.5.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/friends/request-follow.tpl' => 'Fixed escaping issue',
    'views/scripts/friends/request-friend.tpl' => 'Fixed escaping issue',
  ),
  '4.1.4' => array(
    '/application/languages/en/user.csv' => 'Added phrases',
    'controllers/AdminLoginsController.php' => 'Added',
    'controllers/AdminManageController.php' => 'Fixed issue with editing a member',
    'controllers/AdminSignupController.php' => 'Fixed issue with editing signup steps',
    'controllers/AuthController.php' => 'Added login tracking (viewable under Banning & Spam)',
    'controllers/SettingsController.php' => 'Fixes issue with updating displayname when profile address can be changed; Members can now leave hidden networks',
    'externals/styles/admin/main.css' => 'Added',
    'externals/styles/main.css' => 'Added svn:keywords Id',
    'externals/styles/mobile.css' => 'Added',
    'Form/Signup/Account.php' => 'Hides language option when there is only one',
    'Model/DbTable/Logins.php' => 'Added',
    'Model/User.php' => 'Fixed error caused when checking if unregistered visitor is an admin; Sets member name as the email is displayname or username is not set',
    'Plugin/Signup/Fields.php' => 'Fixes issue with profile type not being pre-populated when signup order is changed',
    'Plugin/Signup/Photo.php' => 'Step is disabled now for mobile browsers',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.3-4.1.4.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'View/Helper/UserFriendship.php' => 'Fixed issues with friendship link showing up incorrectly in browse members page',
    'views/scripts/admin-logins/clear.tpl' => 'Added',
    'views/scripts/admin-logins/index.tpl' => 'Added',
    'views/scripts/admin-manage/index.tpl' => 'Added missing localization',
    'views/scripts/admin-manage/stats.tpl' => 'Added neutering for demo mode',
    'views/scripts/settings/network.tpl' => 'Fixes network selection issue with Internet Explorer',
    'widgets/profile-friends-followers/index.tpl' => 'Fixes issues with pagaination',
    'widgets/profile-friends-following/index.tpl' => 'Fixes issues with pagaination',
    'widgets/profile-options/Controller.php' => 'Fixes issue with profile-options widget rendering when member is not logged in',
  ),
  '4.1.3' => array(
    '/application/languages/en/user.csv' => 'Added phrases',
    'controllers/AdminManageController.php' => 'Fixed issue with showing a member before paying for a subscription',
    'controllers/AuthController.php' => 'Fixed issue with showing a member before paying for a subscription, Lost password mail template no longer includes the host and scheme in the object_link placeholder. Use http://[host][object_link] to specify resource URL',
    'controllers/FriendsController.php' => 'Fixed issues with one-way friendships',
    'controllers/ProfileController.php' => 'Fixed issue with showing a member before paying for a subscription',
    'controllers/SettingsController.php' => 'Improvements to network settings page',
    'controllers/SignupController.php' => 'Fixed issue with signup activity not showing up for members in the same networks when feed content is set My Friends & Networks',
    'Form/Admin/Manage/Edit.php' => 'Fixed issue with showing a member before paying for a subscription',
    'Form/Settings/Network.php' => 'Improvements to network settings page',
    'Form/Signup/Photo.php' => 'Remove the image size cap for initial signup',
    'Model/DbTable/Membership.php' => 'Fixes rare issue with deleting members',
    'Model/User.php' => 'Fixed issue with showing a member before paying for a subscription',
    'Plugin/Core.php' => 'Fixed issue with showing a member before paying for a subscription',
    'Plugin/Menus.php' => 'Fixed issues with one-way friendships',
    'Plugin/Signup/Account.php' => 'Fixed issue with signup activity not showing up for members in the same networks when feed content is set My Friends & Networks',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Fixed issues with one-way friendships',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.2-4.1.3.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'View/Helper/UserFriendship.php' => 'Fixed issues with one-way friendships',
    'views/scripts/friends/follow.tpl' => 'Added',
    'views/scripts/friends/request-follow.tpl' => 'Fixed issues with one-way friendships',
    'views/scripts/settings/network.tpl' => 'Improvements to network settings page',
    'widgets/list-online/Controller.php' => 'Fixed issue with showing a member before paying for a subscription',
    'widgets/list-popular/Controller.php' => 'Fixed issue with showing a member before paying for a subscription',
    'widgets/list-signups/Controller.php' => 'Fixed issue with showing a member before paying for a subscription',
    'widgets/profile-friends-common/Controller.php' => 'Fixed issues with one-way friendships',
    'widgets/profile-friends-followers/Controller.php' => 'Added',
    'widgets/profile-friends-followers/index.tpl' => 'Added',
    'widgets/profile-friends-following/Controller.php' => 'Added',
    'widgets/profile-friends-following/index.tpl' => 'Added',
    'widgets/profile-friends/Controller.php' => 'Fixed issues with one-way friendships',
    'widgets/profile-friends/index.tpl' => 'Fixed issues with one-way friendships',
  ),
  '4.1.2' => array(
    '/application/languages/en/user.csv' => 'Added phrases',
    'controllers/AdminManageController.php' => 'Fixed issue with deleted networks, editing a member now closes smoothbox on confirmation; Now sends approval email when the approve selected button is used',
    'controllers/AuthController.php' => 'Added ability to base64 encode return URL',
    'controllers/EditController.php' => 'Added ability to remove profile photo',
    'controllers/FriendsController.php' => 'Fixed issue with friend suggestion',
    'controllers/SettingsController.php' => 'Hides profile posting privacy option on form if there are less than one option',
    'externals/styles/main.css' => 'Added styles',
    'Form/Admin/Account.php' => 'Added ability to disable profile address',
    'Form/Admin/Manage/Edit.php' => 'Added ability to disable profile address',
    'Form/Admin/Settings/Level.php' => 'Added ability to disable profile address',
    'Form/Admin/Signup/Account.php' => 'Added ability to disable profile address',
    'Form/Edit/Photo.php' => 'Added ability to remove profile photo',
    'Form/Edit/RemovePhoto.php' => 'Added',
    'Form/Settings/General.php' => 'Added ability to disable profile address',
    'Form/Settings/Privacy.php' => 'Fixed issue with saving privacy options when the options are hidden',
    'Form/Signup/Account.php' => 'Added ability to disable profile address',
    'Plugin/Menus.php' => 'Fixed incorrect profile URL; added return URL to mini menu login link',
    'Plugin/Signup/Account.php' => 'Added save notice to admin form',
    'Plugin/Signup/Invite.php' => 'Added save notice to admin form',
    'Plugin/Signup/Photo.php' => 'Now works on distributed hosting',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added preliminary layout editor enhancements',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.1-4.1.2.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formSignupImage.tpl' => 'Now works on distributed hosting',
    'views/scripts/admin-signup/index.tpl' => 'Fixed javascript error',
    'views/scripts/edit/remove-photo.tpl' => 'Added',
    'views/scripts/settings/privacy.tpl' => 'Fixes link to unblock members',
    'views/scripts/signup/form/account.tpl' => 'Fixed javascript error',
    'widgets/list-online/Controller.php' => 'Added guest count option',
    'widgets/list-online/index.tpl' => 'Added guest count option',
    'widgets/list-popular/Controller.php' => 'Added configuration options',
  ),
  '4.1.1' => array(
    'controllers/AdminManageController.php' => 'Added network management to edit user',
    'controllers/AuthController.php' => 'Added http_host to lost password link',
    'controllers/SettingsController.php' => 'Removes collate command from passwordAction since it is done at database level now',
    'controllers/SignupController.php' => 'Added welcome email after verification',
    'externals/.htaccess' => 'Added keywords; removed deprecated code',
    'externals/styles/main.css' => 'CSS tweak for displaying long field names on profile info tab',
    'Form/Admin/Facebook.php' => 'Fixed language',
    'Form/Admin/Manage/Edit.php' => 'Added network management to edit user',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.0-4.1.1.sql' => 'Added',
    'settings/my.sql' => 'Incremented version; changes password and salt columns to UTF-8 for collation compatibility',
  ),
  '4.1.0' => array(
    '/application/languages/en/user.csv' => 'Replacing friend list description for admin; fixed phrases with stray double-quotes',
    'Api/Core.php' => 'Fixed issue with numeric usernames',
    'Bootstrap.php' => 'Disabled users are logged out immediately',
    'controllers/AdminManageController.php' => 'Added new edit user options; users are email when they are enabled',
    'controllers/AdminSettingsController.php' => 'Added notice on form save',
    'controllers/AdminSignupController.php' => 'Account step is no longer required to be first to allow for subscription step to be placed first; fixed bugs with step selection',
    'controllers/AuthController.php' => 'Added code to handle subscriptions; tweak to allow for CLI support; added pre/post login hooks; fixed reset password email link',
    'controllers/EditController.php' => 'Optimization for profile photos',
    'controllers/FriendsController.php' => 'Fixed incorect notification parameters',
    'controllers/IndexController.php' => 'Silencing notices in the content system; unverified users no longer appear in browse members; fixed issue with user name search',
    'controllers/ProfileController.php' => 'Silencing notices in the content system; admins do not require verification',
    'controllers/SettingsController.php' => 'Added logging to Facebook exceptions; removed signup feed item type from settings form',
    'controllers/SignupController.php' => 'Fixed undefined variables for $confirmSession',
    'Form/Admin/Manage/Edit.php' => 'Added option to reset a member password',
    'Form/Admin/Manage/Filter.php' => 'Added filtering options; fixed issue with parameter propagation',
    'Form/Admin/Signup/Account.php' => 'Fixed issues with signup step selection in admin edit page',
    'Form/Admin/Signup/Fields.php' => 'Fixed issues with signup step selection in admin edit page',
    'Form/Admin/Signup/Invite.php' => 'Fixed issues with signup step selection in admin edit page',
    'Form/Admin/Signup/Photo.php' => 'Fixed issues with signup step selection in admin edit page',
    'Form/Settings/General.php' => 'Fixed incorrect regex that allowed numeric usernames',
    'Form/Signup/Account.php' => 'Fixed incorrect regex that allowed numeric usernames',
    'Form/Signup/Fields.php' => 'Added form title',
    'Form/Signup/Invite.php' => 'Fixed incorrect submit button label',
    'Form/Signup/Photo.php' => 'Added form title',
    'Model/DbTable/Online.php' => 'Different',
    'Model/User.php' => 'Tweak to allow for CLI support; added isAdmin() method; fixed issue with resetting password after v3 migration',
    'Plugin/Job/Maintenance/RebuildPrivacy.php' => 'Added',
    'Plugin/Menus.php' => 'Fixed active class for home menu item',
    'Plugin/Signup/Account.php' => 'Added support for the account step to not be the first step',
    'Plugin/Signup/Fields.php' => 'Added support for the account step to not be the first step',
    'Plugin/Signup/Invite.php' => 'Added support for the account step to not be the first step',
    'Plugin/Signup/Photo.php' => 'Added support for the account step to not be the first step',
    'Plugin/Task/Maintenance/RebuildPrivacy.php' => 'Removed',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added pagination/item count limits to widgets',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.0rc1-4.0.0rc2.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.3p1-4.0.4.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.4-4.0.5.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.5-4.1.0.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_browseUsers.tpl' => 'Fixed pagination issues on browse members',
    'views/scripts/admin-manage/index.tpl' => 'Fixed pagination issues; added link to member stats page',
    'views/scripts/admin-manage/stats.tpl' => 'Added',
    'views/scripts/admin-signup/index.tpl' => 'Fixed issues with signup step selection in admin edit page',
    'views/scripts/edit/photo.tpl' => 'Fixed notices caused by invalid variable comparison',
    'views/scripts/edit/style.tpl' => 'Fixed notices caused by invalid variable comparison',
    'views/scripts/index/search.tpl' => 'Code formatting',
    'views/scripts/settings/network.tpl' => 'Fixed autosuggest issue',
    'views/scripts/settings/privacy.tpl' => 'Fixed issue where blocked users that had been deleted could cause exceptions',
    'widgets/list-online/Controller.php' => 'Added pagination/item count limit',
    'widgets/list-popular/Controller.php' => 'Added pagination/item count limit',
    'widgets/list-signups/Controller.php' => 'Added pagination/item count limit',
    'widgets/profile-friends-common/Controller.php' => 'Added pagination/item count limit',
    'widgets/profile-friends/Controller.php' => 'Added pagination/item count limit',
    'widgets/profile-friends/index.tpl' => 'Added pagination/item count limit',
    'widgets/profile-info/Controller.php' => 'Fixed networks member belongs to',
    'widgets/profile-tags/Controller.php' => 'Added pagination/item count limit',
    'widgets/profile-tags/index.tpl' => 'Added pagination/item count limit',
  ),
  '4.0.5' => array(
    'Api/Core.php' => 'Auth now stored user id instead of email to prevent issues with changing email addresses',
    'Bootstrap.php' => 'Removed code that could cause javascript errors',
    'controllers/AuthController.php' => 'Fixed security issue with forgot password',
    'controllers/BlockController.php' => 'Removed deprecated context switch code',
    'controllers/FriendsController.php' => 'Removed deprecated context switch code',
    'controllers/IndexController.php' => 'Name search now searches through username; added dependent field support to browse members',
    'controllers/SettingsController.php' => 'Disabled action and notification types no longer show; added network join activity feed item; fixed issue with disabling friendship feed item',
    'controllers/SignupController.php' => 'Resend verification now creates a new code if missing',
    'Form/Block/Add.php' => 'Fixed issue with context switch',
    'Form/Block/Remove.php' => 'Fixed issue with context switch',
    'Form/Friends/Add.php' => 'Fixed issue with context switch',
    'Form/Friends/Cancel.php' => 'Fixed issue with context switch',
    'Form/Friends/Confirm.php' => 'Fixed issue with context switch',
    'Form/Friends/Reject.php' => 'Fixed issue with context switch',
    'Form/Friends/Remove.php' => 'Fixed issue with context switch',
    'Form/Search.php' => 'Added dependent field support to browse members',
    'Form/Settings/Privacy.php' => 'Code formatting',
    'Form/Signup/Fields.php' => 'Added support for disabling fields on signup',
    'Form/Signup/Photo.php' => 'Added missing .jpeg extension to allowed extension list',
    'Model/DbTable/Facebook.php' => 'Logging tweak',
    'Model/DbTable/Forgot.php' => 'Changed garbage collect to 24 hours',
    'Model/User.php' => 'Added missing translation',
    'Plugin/Task/Cleanup.php' => 'Added idle support',
    'Plugin/Task/Maintenance/RebuildPrivacy.php' => 'Added idle support',
    'settings/changelog.php' => 'Added',
    'settings/content.php' => 'Added ability to configure the number of items displayed for certain widgets',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.3p1-4.0.4.sql' => 'Fixed missing category for cleanup task',
    'settings/my-upgrade-4.0.4-4.0.5.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/edit/profile.tpl' => 'Fixed errors caused by object comparison method',
    'views/scripts/index/browse.tpl' => 'Added dependent field support',
    'views/scripts/signup/resend.tpl' => 'Added better error messages',
    'widgets/home-links/Controller.php' => 'Fixed issues with caching regardless of language/locale',
    'widgets/home-photo/Controller.php' => 'Fixed issues with caching regardless of language/locale',
    'widgets/list-online/Controller.php' => 'Count no longer includes disabled/unverified members; fixed issues with caching regardless of language/locale; added ability to configure the number of items displayed for certain widgets',
    'widgets/list-online/index.tpl' => 'Count no longer includes disabled/unverified members',
    'widgets/list-popular/Controller.php' => 'Fixed issues with caching regardless of language/locale; added ability to configure the number of items displayed for certain widgets',
    'widgets/list-popular/index.tpl' => 'Fixed issues with caching regardless of language/locale; added ability to configure the number of items displayed for certain widgets',
    'widgets/list-signups/Controller.php' => 'Fixed issues with caching regardless of language/locale; added ability to configure the number of items displayed for certain widgets',
    'widgets/list-signups/index.tpl' => 'Fixed issues with caching regardless of language/locale; added ability to configure the number of items displayed for certain widgets',
    'widgets/profile-friends/index.tpl' => 'Removed deprecated code',
    '/application/languages/en/user.csv' => 'Added missing phrases',
  ),
  '4.0.4' => array(
    'controllers/AuthController.php' => 'Added params to lost password email',
    'controllers/SettingsController.php' => 'Fixed checking of permissions for showing delete account tab',
    'controllers/SignupController.php' => 'Added params to resend verification email; improved confirmation redirection handling; improved verification error reporting',
    'externals/styles/main.css' => 'Improved RTL support',
    'Form/Search.php' => 'Fixed javascript error',
    'Form/Settings/Privacy.php' => 'Fixed comment option type; adjusted network privacy label',
    'Form/Settings/Delete.php' => 'Removed deprecated code',
    'Form/Signup/Account.php' => 'Code formatting; fixed bug in invite code checking',
    'Form/Signup/Invite.php' => 'Code formatting; added email validation; removed deprecated code',
    'Form/Signup/Photo.php' => 'Removed deprecated code',
    'Model/User.php' => 'Fixed non-optimal level check; now cleans out fields values on delete; fixed issue with resetting password after migration',
    'Plugin/Menus.php' => 'Fixed checking of permissions for showing delete account tab',
    'Plugin/Signup/Account.php' => 'Added params to signup emails; fixed bug in invite code checking',
    'Plugin/Signup/Invite.php' => 'Code formatting; uses common method',
    'Plugin/Task/Cleanup.php' => 'Added docblock',
    'Plugin/Task/Maintenance/RebuildPrivacy.php' => 'Added to fix migration problems',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.3p1-4.0.4.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formButtonCancel.tpl' => 'Removing deprecated code',
    'views/scripts/auth/reset.tpl' => 'Added missing translation',
    'views/scripts/index/browse.tpl' => 'Fixed broken smoothbox binding after searching',
    'views/scripts/signup/confirm.tpl' => 'Fixed incorrect link',
    'views/scripts/signup/index.tpl' => 'Fixed warning message',
    'views/scripts/signup/verify.tpl' => 'Added error messages',
    'widgets/list-online/Controller.php' => 'Fixed locale problems caused by incorrect cache key; now properly excludes members that have opted out',
    'widgets/list-popular/Controller.php' => 'Fixed locale problems caused by incorrect cache key',
    'widgets/list-signups/Controller.php' => 'Fixed locale problems caused by incorrect cache key',
    '/application/languages/en/user.csv' => 'Added phrases',
  ),
  '4.0.3' => array(
    'Api/Core.php' => 'Fixes for empty viewers',
    'controllers/IndexController.php' => 'Disabled members do not show up in browse members page',
    'controllers/ProfileController.php' => 'Admins and moderators can now see disabled member profiles',
    'controllers/SettingsController.php' => 'Proper handling of delete auth; moved notifications to another tab',
    'Form/Settings/General.php' => 'Moved notifications to another tab; added missing translation',
    'Form/Settings/Privacy.php' => 'Respects subject instead of viewer',
    'Model/User.php' => 'Better handling of empty display names',
    'Model/DbTable/Facebook.php' => 'Fixed typo in javascript',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.2-4.0.3.sql' => 'Added',
    'settings/my.sql' => 'Incremented version; moved notifications to another tab',
    'views/scripts/admin-manage/index.tpl' => 'Style tweak',
    'views/scripts/settings/notifications.tpl' => 'Moved notifications to another tab',
    'views/scripts/signup/index.tpl' => 'Fixed missing translation',
    'widgets/list-popular/Controller.php' => 'No longer displays disabled or unverified users',
    'widgets/list-signups/Controller.php' => 'No longer displays disabled or unverified users',
    'widgets/profile-info/index.tpl' => 'Removed link around member type; added missing translation',
    '/application/languages/en/user.csv' => 'Added phrases',
  ),
  '4.0.2' => array(
    'controllers/AdminManageController.php' => 'Added log in as user action',
    'controllers/AuthController.php' => 'Added authentication against SE3 table (if migration tool used)',
    'controllers/EditController.php' => 'Fix for unselected menu',
    'controllers/FriendsController.php' => 'Missing translations',
    'controllers/SettingsController.php' => 'Fixed missing check for invisible networks; fix for unselected menu',
    'externals/scripts/composer_facebook.js' => 'IE compatibility fix',
    'Form/Edit/Photo.php' => 'Removed arbitrary limit on profile photo size',
    'Form/Settings/Privacy.php' => 'Cast element options to array',
    'Form/Signup/Account.php' => 'Fixed a problem with validating the invite code if more than one invite sent to the same email',
    'Model/DbTable/Facebook.php' => 'Facebook ex-user bug fix',
    'Model/User.php' => 'Fixed incorrect photo being used when setting a photo as your profile photo',
    'Plugin/Signup/Photo.php' => 'Fixed notice',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.1-4.0.2.sql' => 'Added',
    'settings/my.sql' => 'Various level settings fixes and enhancements',
    'views/scripts/_formButtonSkipInvite.tpl' => 'Missing translation',
    'views/scripts/_formButtonSkipPhoto.tpl' => 'Missing translation',
    'views/scripts/admin-manage/index.tpl' => 'Added log in as user action',
    'widgets/profile-friends/index.tpl' => 'Fix for orphaned rows in membership table',
    'widgets/profile-info/Controller.php' => 'Fixed missing check for invisible networks',
    'widgets/profile-info/index.tpl' => 'Fixed missing check for invisible networks',
  ),
  '4.0.1' => array(
    'Api/Core.php' => 'Adjustments for trial',
    'controllers/AdminManageController.php' => 'Delete now run in transaction',
    'controllers/AdminSettingsController.php' => 'Fixed problem in level select',
    'controllers/AuthController.php' => 'Facebook fixes; adjustments for trial; faster sending of verification email',
    'controllers/EditController.php' => 'Better cleanup of temporary files and bug fix for making a profile picture',
    'controllers/IndexController.php' => 'Better exception throwing in Facebook module',
    'controllers/SettingsController.php' => 'Fixes forced logout bug when changing email address',
    'controllers/SignupController.php' => 'Fixed bug in resend of verification email',
    'externals/styles/main.css' => 'Style fixes',
    'Form/Login.php' => 'Facebook login bug fixes',
    'Model/User.php' => 'Better cleanup of temporary files',
    'Model/DbTable/Facebook.php' => 'Facebook login refresh bug fix; Facebook wall post fix',
    'Plugin/Signup/Photo.php' => 'Better cleanup of temporary files',
    'settings/manifest.php' => 'Incremented version',
    'widgets/profile-tags/Controller.php' => 'Fixed typos',
  ),
) ?>